<?php
/**
*
* @package phpBB3
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*/
define('IN_PHPBB', true);
define('IN_CRON', true);
$phpbb_root_path = (defined('PHPBB_ROOT_PATH')) ? PHPBB_ROOT_PATH : './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include($phpbb_root_path . 'common.' . $phpEx);

// Do not update users last page entry
$user->session_begin(false);
$auth->acl($user->data);

$cron_type = request_var('cron_type', '');

// Output transparent gif
header('Cache-Control: no-cache');
header('Content-type: image/gif');
header('Content-length: 43');

echo base64_decode('R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==');

// Flush here to prevent browser from showing the page as loading while running cron.
flush();

if (!isset($config['cron_lock']))
{
	set_config('cron_lock', '0', true);
}

// make sure cron doesn't run multiple times in parallel
if ($config['cron_lock'])
{
	// if the other process is running more than an hour already we have to assume it
	// aborted without cleaning the lock
	$time = explode(' ', $config['cron_lock']);
	$time = $time[0];

	if ($time + 3600 >= time())
	{
		exit;
	}
}

define('CRON_ID', time() . ' ' . unique_id());

$sql = 'UPDATE ' . CONFIG_TABLE . "
	SET config_value = '" . $db->sql_escape(CRON_ID) . "'
	WHERE config_name = 'cron_lock' AND config_value = '" . $db->sql_escape($config['cron_lock']) . "'";
$db->sql_query($sql);

// another cron process altered the table between script start and UPDATE query so exit
if ($db->sql_affectedrows() != 1)
{
	exit;
}

/**
* Run cron-like action
* Real cron-based layer will be introduced in 3.2
*/
switch ($cron_type)
{
	case 'queue':

		if (time() - $config['queue_interval'] <= $config['last_queue_run'] || !file_exists($phpbb_root_path . 'cache/queue.' . $phpEx))
		{
			break;
		}

		include_once($phpbb_root_path . 'includes/functions_messenger.' . $phpEx);
		$queue = new queue();

		$queue->process();

	break;

	case 'tidy_cache':

		if (time() - $config['cache_gc'] <= $config['cache_last_gc'] || !method_exists($cache, 'tidy'))
		{
			break;
		}

		$cache->tidy();
	break;

	case 'cgp_tidy_cache':

		if (!class_exists('CGP'))
		{
			include($phpbb_root_path . 'includes/cache_guests_pages.' . $phpEx);
		}

		if (time() - $config['cgp_cache_gc'] <= $config['cgp_cache_last_gc'] || !method_exists(CGP::$cache, 'tidy'))
		{
			break;
		}

		CGP::$cache->tidy();
	break;

	case 't_dtad':
		$forum_id = request_var('f', 0);
		if($config['ppkbb_deadtorrents_autodelete'][0] && $config['ppkbb_deadtorrents_autodelete'][1] && $forum_id!=$config['ppkbb_deadtorrents_autodelete'][3])
		{

			$dt=time();
			$delete_topics=array();
			$sql="SELECT topic_id FROM ".TRACKER_TORRENTS_TABLE." WHERE forum_id='{$forum_id}' AND
				(
					(lastseed!='0' AND {$dt}-lastseed>{$config['ppkbb_deadtorrents_autodelete'][1]}"
						.($config['ppkbb_deadtorrents_autodelete'][2] ? " AND {$dt}-added>{$config['ppkbb_deadtorrents_autodelete'][2]}" : '').")"
						.($config['ppkbb_deadtorrents_autodelete'][2] ? " OR (lastseed='0' AND {$dt}-added>{$config['ppkbb_deadtorrents_autodelete'][2]})" : '')
				.")"
					.($config['ppkbb_deadtorrents_autodelete'][4] ? " AND rem_seeders='0'" : '')
					.($config['ppkbb_deadtorrents_autodelete'][5] ? " LIMIT {$config['ppkbb_deadtorrents_autodelete'][5]}" : '');
			$result=$db->sql_query($sql);
			while($row=$db->sql_fetchrow($result))
			{
				$delete_topics[$row['topic_id']]=$row['topic_id'];
			}
			$db->sql_freeresult($result);
			if(sizeof($delete_topics))
			{
				include_once("{$phpbb_root_path}includes/functions_admin.{$phpEx}");

					delete_topics('topic_id', $delete_topics);
					add_log('mod', $forum_id, 0, 'LOG_DELETE_TOPICS');


				set_tracker_config('ppkbb_last_dtad', "{$dt} {$forum_id}");

			}

		}
	break;

	case 'tidy_search':
		
		// Select the search method
		$search_type = basename($config['search_type']);

		if (time() - $config['search_gc'] <= $config['search_last_gc'] || !file_exists($phpbb_root_path . 'includes/search/' . $search_type . '.' . $phpEx))
		{
			break;
		}

		include_once("{$phpbb_root_path}includes/search/$search_type.$phpEx");

		// We do some additional checks in the module to ensure it can actually be utilised
		$error = false;
		$search = new $search_type($error);

		if ($error)
		{
			break;
		}

		$search->tidy();

	break;

	case 'tidy_warnings':

		if (time() - $config['warnings_gc'] <= $config['warnings_last_gc'])
		{
			break;
		}

		include_once($phpbb_root_path . 'includes/functions_admin.' . $phpEx);

		tidy_warnings();

	break;

	case 'tidy_database':

		if (time() - $config['database_gc'] <= $config['database_last_gc'])
		{
			break;
		}

		include_once($phpbb_root_path . 'includes/functions_admin.' . $phpEx);

		tidy_database();

	break;

	case 'tidy_sessions':

		if (time() - $config['session_gc'] <= $config['session_last_gc'])
		{
			break;
		}

		$user->session_gc();

	break;

	case 'prune_forum':

		$forum_id = request_var('f', 0);

		$sql = 'SELECT forum_id, prune_next, enable_prune, prune_days, prune_viewed, forum_flags, prune_freq
			FROM ' . FORUMS_TABLE . "
			WHERE forum_id = $forum_id";
		$result = $db->sql_query($sql);
		$row = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		if (!$row)
		{
			break;
		}

		// Do the forum Prune thang
		if ($row['prune_next'] < time() && $row['enable_prune'])
		{
			include_once($phpbb_root_path . 'includes/functions_admin.' . $phpEx);

			if ($row['prune_days'])
			{
				auto_prune($row['forum_id'], 'posted', $row['forum_flags'], $row['prune_days'], $row['prune_freq']);
			}

			if ($row['prune_viewed'])
			{
				auto_prune($row['forum_id'], 'viewed', $row['forum_flags'], $row['prune_viewed'], $row['prune_freq']);
			}
		}

	break;
}

// Unloading cache and closing db after having done the dirty work.
unlock_cron();
garbage_collection();

exit;


/**
* Unlock cron script
*/
function unlock_cron()
{
	global $db;

	$sql = 'UPDATE ' . CONFIG_TABLE . "
		SET config_value = '0'
		WHERE config_name = 'cron_lock' AND config_value = '" . $db->sql_escape(CRON_ID) . "'";
	$db->sql_query($sql);
}

?>